﻿using Microsoft.IdentityModel.Clients.ActiveDirectory;
using Microsoft.Xrm.Sdk.WebServiceClient;
using Microsoft.Xrm.Sdk.WebServiceClient.Async;
using System;
using System.Configuration;
using System.Threading.Tasks;

namespace VA.PPMS.Context
{
    public class PpmsContextHelper
    {
        private static string _token;
        private static DateTime _expires = DateTime.Now;

        public static async Task<PpmsContext> GetContext()
        {
            return new PpmsContext(await GetProxy());
        }
        
        public static async Task<OrganizationWebProxyAsyncClient> GetProxy()
        {
            if (string.IsNullOrEmpty(_token) || DateTime.Now.ToUniversalTime() >= _expires)
            {
                _token = await GetToken();
            }

            var connectionName = ConfigurationManager.AppSettings["ConnectionName"];
            string baseCrmUri = "";
            switch (connectionName)
            {
                case "DEV":
                    baseCrmUri = ConfigurationManager.AppSettings["DEVbaseCrmUri"];                
                    break;
                case "NON-PROD":
                    baseCrmUri = ConfigurationManager.AppSettings["NONPRODbaseCrmUri"];                 
                    break;
                case "PROD":
                    baseCrmUri = ConfigurationManager.AppSettings["PRODbaseCrmUri"];                 
                    break;
                default:
                    //IF connection name was mis-typed just set connection to DEV. 
                    baseCrmUri = ConfigurationManager.AppSettings["DEVbaseCrmUri"];
                    break;
            }
            //var baseCrmUri = ConfigurationManager.AppSettings["baseCrmUri"];
            var client = new OrganizationWebProxyClient(new Uri(string.Format("{0}/XRMServices/2011/Organization.svc/web", baseCrmUri)), typeof(Account).Assembly) { HeaderToken = _token };

            return client.ToAsyncClient();
        }
        
        public static async Task<string> GetToken()
        {
            var connectionName = ConfigurationManager.AppSettings["ConnectionName"];

            string baseCrmUri = "";
            string clientId = "";
            string clientSecret = "";
            switch (connectionName)
            {
                case "DEV":
                    baseCrmUri = ConfigurationManager.AppSettings["DEVbaseCrmUri"];
                    clientId = ConfigurationManager.AppSettings["DEVclientId"];
                    clientSecret = ConfigurationManager.AppSettings["DEVclientSecret"];
                    break;
                case "NON-PROD":
                    baseCrmUri = ConfigurationManager.AppSettings["NONPRODbaseCrmUri"];
                    clientId = ConfigurationManager.AppSettings["NONPRODclientId"];
                    clientSecret = ConfigurationManager.AppSettings["NONPRODclientSecret"];
                    break;
                case "PROD":
                    baseCrmUri = ConfigurationManager.AppSettings["PRODbaseCrmUri"];
                    clientId = ConfigurationManager.AppSettings["PRODclientId"];
                    clientSecret = ConfigurationManager.AppSettings["PRODclientSecret"];
                    break;
                default:
                    //IF connection name was mis-typed just set connection to DEV. 
                    baseCrmUri = ConfigurationManager.AppSettings["DEVbaseCrmUri"];
                    clientId = ConfigurationManager.AppSettings["DEVclientId"];
                    clientSecret = ConfigurationManager.AppSettings["DEVclientSecret"];
                    break;
            }

            //var baseCrmUri = ConfigurationManager.AppSettings["baseCrmUri"];
            


            var ap = await AuthenticationParameters.CreateFromResourceUrlAsync(new Uri(string.Format("{0}/api/data/", baseCrmUri)));
            var authorityUrl = ap.Authority;
            var resourceUrl = ap.Resource;
            var authContext = new AuthenticationContext(authorityUrl, true, TokenCache.DefaultShared);

            //var clientId = ConfigurationManager.AppSettings["clientId"];
            //var clientSecret = ConfigurationManager.AppSettings["clientSecret"];
            var clientCredential = new ClientCredential(clientId, clientSecret);

            var token = await authContext.AcquireTokenAsync(resourceUrl, clientCredential);
            _expires = token.ExpiresOn.DateTime;
            var result = token.AccessToken;

            return result;
        }
    }
}